--============================================================================
EditorHelpScreen = 0
Editor = 
{
    Enabled = false,
    EditWayPoints = 0,
    EditFloors = 0,
    EditAcousticEnvs = false,    
    EditAreas = false,
    EditLights = false,
    EditSounds = false,
    EditBillboardsAndDecals = false,
    SelObj = nil, -- reference to selected object
    ToSelObj = nil,
    ObjEdited = false,
    LockMouse = false,
    LockAxis = false,
    IsRect = false,

    ofx=0,  
    ofy=0,
    Axis = "X",
    LMX=0,LMY=0,
    matLight = -1,
    matSound = -1,
    dir = Vector:New(0,0,0),
}

EditorHelp = {

	CMRHotKeys 		= " - Comands for to control the camera -",
	SLABHotKeys 		= " - Comands for Slabs -",
	AMMUNITIONHotKeys 	= " - Comands for Ammo -",
	AREAPOINTHotKeys 	= " - Comands for Area Object -",
	WAYPOINTSHotKeys 	= " - Comands for WayPoint Editor -",
	ITEMHotKeys 		= " - Comands for Object Class 'CItem' -",
	LIGHTHotKeys 		= " - Comands for Object Class 'CLight' -",
	AMBUSHBOXHotKeys 	= " - Comands for Object Class 'CBox' -",
	SPAWNHotKeys 		= " - Comands for Object Class 'CSpawnPoint' -",
	PARTICLEHotKeys 	= " - Comands for Object Class 'CParticleFX' -",
	BILLBOARDHotKeys 	= " - Comands for Object Class 'CBillboard' -",
	SOUNDHotKeys 		= " - Comands for Object Class 'CSound' -",

	ITMsetImpulse 		= "Shift+Q+Num+/Num- - Set Impulse Strenght to object",
	ITMMoveImpulse 		= "Shift+Q+Left Mouse - Move Impulse Point relatively at object",
	ITMRagdoll 		= "Shift+Z - Enable/Disable Ragdoll",
	ITMReset 		= "Shift+R - Reset Object",
	ITMSave 		= "Shift+S - Save Object",
	ITMResetRot 		= "Shift+V - Reset Rotation to Object",
	ITMRot 			= "Shift+Ctrl+V - Rotate Object to 90/180/240 degrees",
	ITMClone 		= "Shift+C - Clone Object oppositive to camera",
	ITMSameClone 		= "Shift+Ctrl+C - Clone Object to same place",
	ITMMoveCameraToObj 	= "Shift+X - Move camera to object",
	ITMDelete 		= "Shift+Delete - Delete object from scene",
	ITMMoveObjToCamera 	= "Shift+G - Move object oppositive to camera",
	ITMUpdate 		= "Shift+U - Update object",
	ITMScale 		= "Shift+MouseWheel Up/Down - Scale object",
	ITMRenderImpulse 	= "Shift+Num+/Num - Render Impulse to object",
	ITMTestImpulse 		= "Shift+Q+E - Test Impulse Point for object",
	ITMdrawJoints 		= "Shift+T - Render Joint names for Object (if Object use PKMDL)",
	ITMRotDegree 		= "Shift+A+Rotation - +/- 15 Degree Rotation",

	SLBReset 		= "Shift+R - Reset Slab",
	SLBSave 		= "Shift+S - Save Slab",
	SLBResetRot 		= "Shift+V - Reset Rotation to Slab",
	SLBRot 			= "Shift+Ctrl+V - Rotate Slab to 90/180/240 degrees",
	SLBClone 		= "Shift+C - Clone Slab oppositive to camera",
	SLBSameClone 		= "Shift+Ctrl+C - Clone Slab to same place",
	SLBMoveCameraToObj 	= "Shift+X - Move camera to Slab",
	SLBDelete 		= "Shift+Delete - Delete Slab from scene",
	SLBMoveObjToCamera 	= "Shift+G - Move Slab oppositive to camera",
	SLBOpenClose 		= "Shift+T - Open/Close Slab",
	SLBUpdate 		= "Shift+U - Update Slab",
	SLBScale 		= "Shift+MouseWheel Up/Down - Scale Slab",
	SLBRotDegree 		= "Shift+A+Rotation - +/- 15 Degree Rotation",

	AMMOReset 		= "Shift+R - Reset Ammo",
	AMMOSave 		= "Shift+S - Save Ammo",
	AMMOResetRot 		= "Shift+V - Reset Rotation to Ammo",
	AMMORot 		= "Shift+Ctrl+V - Rotate Ammo to 90/180/240 degrees",
	AMMOClone 		= "Shift+C - Clone Ammo oppositive to camera",
	AMMOSameClone 		= "Shift+Ctrl+C - Clone Ammo to same place",
	AMMOMoveCameraToObj 	= "Shift+X - Move camera to Ammo",
	AMMOMoveObjToCamera 	= "Shift+G - Move Ammo oppositive to camera",
	AMMODelete 		= "Shift+Delete - Delete Ammo from scene",
	AMMOMultiply 		= "Shift+T - Multiply Ammo in selected Ammobox",
	AMMOUpdate 		= "Shift+U - Update Ammo Item",
	AMMOScale 		= "Shift+MouseWheel Up/Down - Scale Ammo",
	AMMOFindallAmmo		= "Shift+Ctrl - Show all Ammo on the map",
	AMMORotDegree 		= "Shift+A+Rotation - +/- 15 Degree Rotation",

	LGHTIntensity 		= "Shift+Ctrl+MouseWheel Up/Down - Change Intensity",
	LGHTRange 		= "Shift+MouseWheel Up/Down - Change Range",
	LGHTReset 		= "Shift+R - Reset light",
	LGHTSave 		= "Shift+S - Save light",
	LGHTClone 		= "Shift+C - Clone light oppositive to camera",
	LGHTSameClone 		= "Shift+Ctrl+C - Clone light to same place",
	LGHTMoveCameraToObj 	= "Shift+X - Move camera to light",
	LGHTDelete 		= "Shift+Delete - Delete light from scene",
	LGHTMoveObjToCamera 	= "Shift+G - Move light oppositive to camera",
	LGHTRenderIntensity 	= "Q - Render Intensity",

	CBOXReset 		= "Shift+R - Reset Zone",
	CBOXSave 		= "Shift+S - Save Zone",
	CBOXClone 		= "Shift+C - Clone Zone oppositive to camera",
	CBOXSameClone 		= "Shift+Ctrl+C - Clone Zone to same place",
	CBOXMoveCameraToObj 	= "Shift+X - Move Zone to object",
	CBOXDelete 		= "Shift+Delete - Delete Zone from scene",
	CBOXMoveObjToCamera 	= "Shift+G - Move Zone oppositive to camera",

	CAREAAdd 		= "Shift+A - Add new Area Point",
	CAREADelete 		= "Shift+D - Delete selected Area Point",
	CAREAAddmidway 		= "Shift+V - Add Area Point midway between selected and next",
	CAREAMove 		= "Shift+Ctrl+Left Mouse - Move all Area Points",
	CAREARotPointerforward 	= "Shift+Z - Move Area Pointer clockwise",
	CAREARotPointerback 	= "Shift+Ctrl+Z - Move Area Pointer counterclock-wise",
	CAREARenderPath 	= "Shift+Ctrl+C - Render path for selected Area",

	SPTReset 		= "Shift+R - Reset Spawn Point",
	SPTSave 		= "Shift+S - Save Spawn Point",
	SPTClone 		= "Shift+C - Clone Spawn Point oppositive to camera",
	SPTSameClone 		= "Shift+Ctrl+C - Clone Spawn Point to same place",
	SPTMoveCameraToObj 	= "Shift+X - Move camera to Spawn Point",
	SPTDelete 		= "Shift+Delete - Delete Spawn Point from scene",
	SPTMoveObjToCamera 	= "Shift+G - Move Spawn Point oppositive to camera",
	SPTSpawn 		= "Shift+T - Launch Test Spawn",
	SPTResetSpawnAngle 	= "Shift+V - Reset custom Spawn Angle for Spawn Point",
	SPTSetSpawnAngleForward = "Shift+Z - Set Spawn Angle clockwise",
	SPTSetSpawnAngleBack 	= "Shift+Ctrl+Z - Set Spawn Angle counterclock-wise",
	SPTRenderMonstersCount 	= "Q - Render Monsters Count in Spawn Point",
	SPTFindallspawns	= "Shift+Ctrl - Show all Spawn Points on the map",

	PRTCLReset 		= "Shift+R - Reset Particle",
	PRTCLSave 		= "Shift+S - Save Particle",
	PRTCLClone 		= "Shift+C - Clone Particle oppositive to camera",
	PRTCLSameClone 		= "Shift+Ctrl+C - Clone Particle to same place",
	PRTCLMoveCameraToObj 	= "Shift+X - Move camera to Particle",
	PRTCLDelete 		= "Shift+Delete - Delete Particle from scene",
	PRTCLMoveObjToCamera 	= "Shift+G - Move Particle oppositive to camera",
	PRTCLResetRot 		= "Shift+V - Reset Particle rotation",
	PRTCLRotDegree 		= "Shift+A+Rotation - +/- 15 Degree Rotation",
	PRTCLScale 		= "Shift+MouseWheel Up/Down - Scale Particle",

	BLBRDReset 		= "Shift+R - Reset Billboard",
	BLBRDSave 		= "Shift+S - Save Billboard",
	BLBRDClone 		= "Shift+C - Clone Billboard oppositive to camera",
	BLBRDSameClone 		= "Shift+Ctrl+C - Clone Billboard to same place",
	BLBRDMoveCameraToObj 	= "Shift+X - Move camera to Billboard",
	BLBRDDelete 		= "Shift+Delete - Delete Billboard from scene",
	BLBRDMoveObjToCamera 	= "Shift+G - Move Billboard oppositive to camera",
	BLBRDScale 		= "Shift+MouseWheel Up/Down - Scale Billboard",

	SNDReset 		= "Shift+R - Reset Sound",
	SNDSave 		= "Shift+S - Save Sound",
	SNDClone 		= "Shift+C - Clone Sound oppositive to camera",
	SNDSameClone 		= "Shift+Ctrl+C - Clone Sound to same place",
	SNDMoveCameraToObj 	= "Shift+X - Move camera to Sound",
	SNDDelete 		= "Shift+Delete - Delete Sound from scene",
	SNDMoveObjToCamera 	= "Shift+G - Move Sound oppositive to camera",
	SNDScalefallofStart	= "Shift+Ctrl+MouseWheel Up/Down - Scale Sound fallof start",
	SNDScalefallofEnd	= "Shift+MouseWheel Up/Down - Scale Sound fallof end",
	SNDVolume		= "Shift+Q+MouseWheel Up/Down - Set Sound Volume",
	SNDRenderVolume		= "Q - Render Sound Volume",
	SNDPlay			= "Shift+T - Play Sound",

	WPTDelete 		= "Shift+X - Delete Selected Points",
	WPTUnselect 		= "U - Unselect all Points",
	WPTAddOne 		= "Shift+Middle Mouse - Add 1 Point to select",
	WPTSelectSet 		= "Shift+Ctrl+Left Mouse - Select Point Set",
	WPTDeactivateSet 	= "Shift+Ctrl+Right Mouse - Deactivate Point Set (Twice to remove block Set)",

	CAMIncreaseSpreed	= "Q - Increase camera speed by 2.5 times",

}
--============================================================================
function Editor:Init()
    if not self.Enabled then return end
    EWayPoints:Init()    
    if Lev then EDITOR.OnMsg("SelectObject",Lev._Name) end

    self.matLight = MATERIAL.Create("Editor/light")
    self.matSound = MATERIAL.Create("Editor/sound")    
end
--============================================================================
function Editor:EditorShowHelp()
	local i = 0
	local posy, textHeight
	local searchString
	local titleString
	
	HUD.SetFont("tahomabd",14)
	textHeight = HUD.GetTextHeight() + 8

	-- title
	if EditorHelpScreen == 1 then
		titleString = "ITEMHotKeys"		searchString = "ITM"
	elseif EditorHelpScreen == 2 then
		titleString = "SLABHotKeys"		searchString = "SLB"
	elseif EditorHelpScreen == 3 then
		titleString = "AMMUNITIONHotKeys"	searchString = "AMMO"
	elseif EditorHelpScreen == 4 then
		titleString = "LIGHTHotKeys"		searchString = "LGHT"
	elseif EditorHelpScreen == 5 then
		titleString = "AMBUSHBOXHotKeys"	searchString = "CBOX"
	elseif EditorHelpScreen == 6 then
		titleString = "AREAPOINTHotKeys"	searchString = "CAREA"
	elseif EditorHelpScreen == 8 then
		titleString = "SPAWNHotKeys"		searchString = "SPT"
	elseif EditorHelpScreen == 9 then
		titleString = "PARTICLEHotKeys"		searchString = "PRTCL"
	elseif EditorHelpScreen == 10 then
		titleString = "BILLBOARDHotKeys"	searchString = "BLBRD"
	elseif EditorHelpScreen == 11 then
		titleString = "WAYPOINTSHotKeys"	searchString = "WPT"
	elseif EditorHelpScreen == 12 then
		titleString = "CMRHotKeys"		searchString = "CAM"
	elseif EditorHelpScreen == 13 then
		titleString = "SOUNDHotKeys"		searchString = "SND"
	end

		HUD.PrintXY(15, 132, EditorHelp[titleString], "tahomabd", 33, 33, 33, 15)	-- Shadow
		HUD.PrintXY(10, 130, EditorHelp[titleString], "tahomabd", 230, 161, 97, 15)

	for s in EditorHelp do
		if string.find(s, searchString, 1, true) then
			i = i + 1
			posy = 130 + (i * textHeight)
			HUD.PrintXY(15, posy+2, EditorHelp[s], "timesbd", 33, 33, 33, 18)	-- Shadow
			HUD.PrintXY(10, posy, EditorHelp[s], "timesbd", 220, 220, 220, 18)
		end
	end	
end
--=======================================================
function Editor:RenderHelp()

	--self._RenderHelp = true
	if not self.SelObj then EditorHelpScreen = 0 end
	if self.EditWayPoints == 1 then EditorHelpScreen = 11 end

	for i,v in GObjects.Elements do
		if self.SelObj and self.EditSounds and self.SelObj._Class == "CSound" then
			EditorHelpScreen = 13

		elseif self.SelObj and self.EditBillboardsAndDecals and self.SelObj._Class == "CBillboard" then
			EditorHelpScreen = 10

		elseif self.SelObj and self.EditBillboardsAndDecals and self.SelObj._Class == "CParticleFX" then
			EditorHelpScreen = 9

		elseif self.SelObj and self.EditAreas and self.SelObj._Class == "CSpawnPoint" then
			EditorHelpScreen = 8

		elseif self.SelObj and self.EditAreas and self.SelObj._Class == "CArea" then
			EditorHelpScreen = 6

		elseif self.SelObj and (self.EditAreas or self.EditAcousticEnvs) and self.SelObj._Class == "CBox" then
			EditorHelpScreen = 5

		elseif self.SelObj and self.EditLights and self.SelObj._Class == "CLight" then
			EditorHelpScreen = 4

		elseif self.SelObj and self.SelObj._DetectAmmo then
			EditorHelpScreen = 3

		elseif self.SelObj and (self.SelObj.BaseObj == "Slab.CItem" or self.SelObj.BaseObj == "SlabDoor.CItem" or self.SelObj.BaseObj == "SlabDoorRot.CItem") then
			EditorHelpScreen = 2

		elseif self.SelObj and self.SelObj._Class == "CItem" then
			EditorHelpScreen = 1
	--	else
	--		EditorHelpScreen = 12
		end
	end
end
--============================================================================
function Editor:Tick(delta)

	if INP.Key(Keys.I) == 1 then
		self:RenderHelp()
		if self.SelObj then PlaySound2D("misc/Editor/Editor_OpenHelp") end
	end

    local menuActive = PMENU.Active()
    if not self.Enabled or menuActive then return end
    self.ObjEdited  = false

    local dx = (OMX - MX) * 0.05
    local dy = (OMY - MY) * 0.05
    self.LockMouse = false
        
    if MOUSE.RB() == 1 or MOUSE.LB() == 1 or MOUSE.MB() == 1 then
        self.LMX = MX
        self.LMY = MY
        self.ofx = 0
        self.ofy = 0
    end
   
    if INP.Key(Keys.LeftShift) == 2 then        
        self.ObjEdited = self:ObjectControl(dx,dy,delta)        
        if not self.ObjEdited then
            GObjects:EditTick(delta)
        elseif self.SelObj.EditTick then            
            self.SelObj:EditTick(delta)
        end
        if self.EditWayPoints == 1 then 
            EWayPoints:Tick(delta) 
        elseif self.EditFloors == 1 then 
            EFloors:Tick(delta) 
        elseif not self.ObjEdited then 
            self.ToSelObj = self:TrySelectObject()
        end        
            
        if INP.Key(Keys.K0)== 1 and self.SelObj and (self.SelObj.Rot or self.SelObj._Rot) then
            if self.SelObj.Rot then 
                self.SelObj.Rot = Quaternion:New()
                self.SelObj.Rot:ToEntity(self.SelObj._Entity)
            end
            if self.SelObj._Rot then 
                self.SelObj._Rot = Quaternion:New()
                self.SelObj._Rot:ToEntity(self.SelObj._Entity)
            end
        end
        if MOUSE.LB() == 1 or MOUSE.RB() == 1 then 
            self.IsRect = true  
        end
    else
        self:CameraControl(dx,dy,delta)
    end    
    
    if self.SelObj then
        if self.SelObj.Synchronize then self.SelObj:Synchronize() end
        if self.SelObj._Synchronize then self.SelObj:_Synchronize() end
    end

    if MOUSE.LB() == 3 or MOUSE.RB() == 3  or self.SelObj then  
        self.IsRect = false 
    end
    
    if self.LockMouse == true then
        MX,MY = self.LMX,self.LMY            
        MOUSE.SetPos(MX,MY)        
    end     
    
    if self.ToSelObj then
        self.SelObj = self.ToSelObj
        EDITOR.OnMsg("SelectObject",self.SelObj._Name) 
        if self.SelObj == Player then 
            self.SelObj = nil 
        end 
    end
    self.ToSelObj = nil    
    
    if INP.Key(Keys.LeftShift) == 2 and INP.Key(Keys.Z)== 1 and
       self.SelObj and self.SelObj._Entity then        
        
        local active = ENTITY.PO_IsEnabled(self.SelObj._Entity)
        if active then 
            Game:Print("Physics Object - deactivated")            
        else
            Game:Print("Physics Object - activated")
        end
        ENTITY.PO_Enable(self.SelObj._Entity,not active)
-------------------
	if Editor.SelObj.Pinned then Editor.SelObj.Pinned = false Editor.SelObj:Apply() else Editor.SelObj.Pinned = true Editor.SelObj:Apply() end
-------------------
        if ENTITY.GetType(self.SelObj._Entity) ==  ETypes.Model then        
            active = MDL.IsRagdoll(self.SelObj._Entity)        
            if active then 
                Game:Print("Ragdoll - deactivated")
            else
                Game:Print("Ragdoll - activated")
            end
            MDL.EnableRagdoll(self.SelObj._Entity,not active,ECollisionGroups.RagdollNonColliding)
        end
    end    
    
    if self.SelObj and self.SelObj._ToKill then self.SelObj = nil end
    
end
--============================================================================
function Editor:TrySelectObject()
    if MOUSE.LB() == 1 then
	local useHavok = (INP.Key(Keys.A) == 2)
        local e = ENTITY.Pick(MX,MY,useHavok)        
        --Game:Print(e)
        local obj = EntityToObject[e]
        if obj then Game:Print(obj._Name) end
        self:SelectObject(obj)
        --if INP.Key(Keys.A) == 2 and e>0 and not obj then
	if e>0 and not obj then
            if ENTITY.GetType(e) ==  ETypes.Mesh then        
                Editor_EditEntity(e,"EMesh")
                EDITOR.OnMsg("SelectObject","EdEntity")         
            end
        end
        return obj
    end
    return nil
end
--============================================================================
function Editor:ObjectControl(dx,dy,delta)    
    if not self.SelObj or not self.SelObj.Pos then return false end                      
    if self.SelObj._Class == "CArea" then return false end

    local obj = self.SelObj      
    local ox,oy,oz = obj.Pos:Get()
    
    if obj._Entity and obj._Class ~= "CDecal" then ox,oy,oz = ENTITY.GetPosition(obj._Entity) end
    if obj.Impulse and INP.Key(Keys.Q) == 2 then 
        ox,oy,oz = obj.Impulse.Pos:Get() 
        ox = ox + obj.Pos.X
        oy = oy + obj.Pos.Y
        oz = oz + obj.Pos.Z
    end

    local ax,ay,az = 0,0,0
    if obj.angle then ax,ay,az = 0, obj.angle, 0  end
    if obj.Rot   then ax,ay,az = 0,0,0            end

    local rot = nil
    if INP.Key(Keys.LeftCtrl) == 2 then rot = self.SelObj.Rot end    
    local edited,x,y,z,ax,ay,az = Editor:MoveByAxis(ox,oy,oz,ax,ay,az,rot)        
    if edited then 
        if obj.Impulse and INP.Key(Keys.Q) == 2 then 
            obj.Impulse.Rot:RotateByAngleAxis(ax,self.dir.X,self.dir.Y,self.dir.Z)
            obj.Impulse.Pos:Set(x-obj.Pos.X,y-obj.Pos.Y,z-obj.Pos.Z)
        else    
            if obj._Entity and obj._Class ~= "CDecal" then ENTITY.SetVelocity(obj._Entity,0,0,0) end
            if obj.Rot then            
                if obj._Entity and obj._Class ~= "CDecal" then obj.Rot:FromEntity(obj._Entity) end                                
                obj.Rot:RotateByAngleAxis(ax,self.dir.X,self.dir.Y,self.dir.Z)
                if obj._Entity and obj._Class ~= "CDecal" then
                    obj.Rot:ToEntity(obj._Entity)
                    obj.Rot:FromEntity(obj._Entity) -- normalized
                end
            elseif obj._Rot then            
                obj._Rot:RotateByAngleAxis(ax,self.dir.X,self.dir.Y,self.dir.Z)                
            elseif obj.angle then
                if obj._Entity then ENTITY.SetOrientation(obj._Entity,obj.angle-ax) end
                obj.angle = obj.angle-ax
                obj._angleDest = obj.angle
            end
            if obj._Entity and obj._Class ~= "CDecal" then ENTITY.SetPosition(obj._Entity,x,y,z) end
    
            if obj.Synchronize then obj:Synchronize() end
            if obj._Synchronize then obj:_Synchronize() end
            
            obj.Pos:Set(x,y,z)
            if obj.EditOnChangePosition then obj:EditOnChangePosition() end
        end
    end
    
    return edited
end
--============================================================================
function Editor:CameraControl(dx,dy,delta)
       
    local cpos = Clone(Lev.Pos)
    local cang = Clone(Lev.Ang)
    local move = Vector:New(0,0,0)
    local speed = 0.8

    if INP.Key(Keys.LeftCtrl) ~= 2 then

	if INP.Key(Keys.Q) == 2 then speed = 2 end

        -- Camera movement
        if INP.Key(Keys.W) == 2 then 
            local x,y,z = CAM.GetForwardVector() 
            move:Add(x,y,z)
        end
        if INP.Key(Keys.S) == 2 then 
            local x,y,z = CAM.GetForwardVector() 
            move:Sub(x,y,z)
        end
        if INP.Key(Keys.D) == 2 then 
            local x,y,z = CAM.GetRightVector() 
            move:Add(x,y,z)
        end
        if INP.Key(Keys.A) == 2 then 
            local x,y,z = CAM.GetRightVector() 
            move:Sub(x,y,z)
        end        
    end
    
    -- only for keyboards
    move:MulByFloat(delta*35)
      
    if MOUSE.LB() == 2 then  
        local fx,fy,fz = CAM.GetForwardVector() 
        move:Add(fx*dy,fy*dy,fz*dy)        
        self.LockMouse = true        
    end   

    if MOUSE.RB() == 2 and MOUSE.LB() ~= 2  then  
        cang.X = cang.X - dx * 3
        cang.Y = cang.Y - dy * 3
        Lev.Ang:Set(cang)
        self.LockMouse = true
    end   
  
    if MOUSE.LB() == 2 and MOUSE.RB() == 2 then  
        move = Vector:New(0,0,0)
        local ux,uy,uz = CAM.GetUpVector() 
        local rx,ry,rz = CAM.GetRightVector()             
        move:Add(ux*dy+rx*-dx,uy*dy+ry*-dx,uz*dy+rz*-dx)
        self.LockMouse = true
    end   
    
    cpos.X = cpos.X + move.X * speed
    cpos.Y = cpos.Y + move.Y * speed
    cpos.Z = cpos.Z + move.Z * speed
    Lev.Pos:Set(cpos)
end
--============================================================================
function Editor:Render(delta)
    
    if not self.Enabled then return end

	if EditorHelpScreen > 0 then Editor.EditorShowHelp() end

    --R3D.RenderLine(1,1,1,1,1,1,R3D.RGB(200,0,0))
    GObjects:EditRender(delta)
    if self.SelObj and self.SelObj.Pos and self.SelObj._Class ~= "CArea" then
        if self.SelObj.Impulse and INP.Key(Keys.Q) == 2 then 
            self:DrawAxis(self.SelObj.Impulse.Pos.X+self.SelObj.Pos.X,self.SelObj.Impulse.Pos.Y+self.SelObj.Pos.Y,self.SelObj.Impulse.Pos.Z+self.SelObj.Pos.Z)
        else
            if INP.Key(Keys.LeftCtrl) == 2 then 
                self:DrawAxis(self.SelObj.Pos.X,self.SelObj.Pos.Y,self.SelObj.Pos.Z,self.SelObj.Rot)
            else
                self:DrawAxis(self.SelObj.Pos:Get())
            end
        end
    end

    if self.IsRect then
        HUD.DrawRect(self.LMX,self.LMY,MX,MY,R3D.RGB(55,255,55))
    end
       
    if self.SelObj and self.SelObj._Entity then 
        ENTITY.RenderBBox(self.SelObj._Entity) 
    end
    if self.EditWayPoints == 1 then EWayPoints:Render() end        
end
--============================================================================
function Editor:OnMsg(msg,value)    
    if msg == "OnEnableWPEdit" then self.EditWayPoints = value end    
    if msg == "OnEnableFloorsEdit" then self.EditFloors = value end
    if msg == "OnEnableAreas" then self.EditAreas = value end
    if msg == "OnEnableLights" then self.EditLights = value end
    if msg == "OnEnableSounds" then self.EditSounds = value end
    if msg == "OnEnableAcousticEnvs" then self.EditAcousticEnvs = value end    
    self.SelObj = nil    
end
--============================================================================
function Editor:SelectObject(obj)
    EdEntity = nil
    if not obj then 
        self.SelObj = nil 
        return
    end      
    self.ToSelObj = obj    
    if obj.Synchronize then obj:Synchronize() end
    if obj._Synchronize then obj:_Synchronize() end
end
--============================================================================
function Editor:FindFreeName(name)    
    
    local l = string.len(name)
    for i=l,1,-1 do 
        local code = string.byte(string.sub(name,i,i))
        if  code < string.byte('0') or code > string.byte('9') then
            name = string.sub(name,1,i)
            break
        end
    end
        
    for i=1,9999 do
        local fname = name .. string.format("%03d",i)
        if not getfenv()[fname] then return fname end
    end
    return TempObjName()
end
--============================================================================
function Editor:CloneObject(obj,thesameplace)    
    local o = GObjects:Clone(self:FindFreeName(obj._Name),obj)   
    if not thesameplace then
        o.Pos = OppositeToCamera()
    else
        o.Pos = Clone(obj.Pos)
    end    
    o:Apply()    
    EDITOR.OnMsg("SelectObject",o._Name) 
    ENTITY.PO_Enable(o._Entity,false)
    return o
end
--============================================================================
function Editor:AddObject(obj,name)
    if not name then name = self:FindFreeName(obj._Name.."_") end 
    local o = GObjects:Add(name,obj)   
    o.Pos = OppositeToCamera()
    o:Apply()
    EDITOR.OnMsg("SelectObject",name) 
    return o
end
--============================================================================
function Editor:DrawAxis(x,y,z,rot)    
   
    local l = R3D.DistToCamera(x,y,z) * 0.20    
    local bs = l * 0.04
    
    local x1,y1,z1 = l,0,0
    if rot then x1,y1,z1 = rot:TransformVector(x1,y1,z1) end
    R3D.RenderLine(x,y,z,x+x1,y+y1,z+z1,R3D.RGB(200,0,0),false)
    R3D.RenderBox(x+x1-bs,y+y1-bs,z+z1-bs,x+x1+bs,y+y1+bs,z+z1+bs,R3D.RGB(200,100,100),false)
    
    local x1,y1,z1 = 0,l,0
    if rot then x1,y1,z1 = rot:TransformVector(x1,y1,z1) end
    R3D.RenderLine(x,y,z,x+x1,y+y1,z+z1,R3D.RGB(0,200,0),false)
    R3D.RenderBox(x+x1-bs,y+y1-bs,z+z1-bs,x+x1+bs,y+y1+bs,z+z1+bs,R3D.RGB(100,200,100),false)

    local x1,y1,z1 = 0,0,l
    if rot then x1,y1,z1 = rot:TransformVector(x1,y1,z1) end
    R3D.RenderLine(x,y,z,x+x1,y+y1,z+z1,R3D.RGB(0,0,200),false)
    R3D.RenderBox(x+x1-bs,y+y1-bs,z+z1-bs,x+x1+bs,y+y1+bs,z+z1+bs,R3D.RGB(100,100,200),false)
        

    R3D.RenderBox(x-bs,y-bs,z-bs,x+bs,y+bs,z+bs,R3D.RGB(50,50,50),false)
end
--============================================================================
function Editor:MoveByAxis(x,y,z,ax,ay,az,rot)
    
    local edited = false        
    local sx,sy,sz = R3D.VectorToScreen(x,y,z)            
    local l = R3D.DistToCamera(x,y,z) * 0.20

    if MOUSE.LB() == 1 or  (MOUSE.RB() == 1 and (self.SelObj.Ang or self.SelObj.Rot or self.SelObj._Rot or self.SelObj.angle))then          
        
        local x1,y1,z1 = l,0,0
        if rot then x1,y1,z1 = rot:TransformVector(x1,y1,z1) end
        local sx1,sy1 = R3D.VectorToScreen(x+x1,y+y1,z+z1)    
        if R3D.DistToLine2D(MX,MY,sx,sy,sx1,sy1) < 10 then 
            self.LockAxis = true
            self.Axis = 'X'
            edited = true
            self.dir:Set(x1,y1,z1)
        end

        local x1,y1,z1 = 0,0,l
        if rot then x1,y1,z1 = rot:TransformVector(x1,y1,z1) end
        local sx1,sy1 = R3D.VectorToScreen(x+x1,y+y1,z+z1)    
        if R3D.DistToLine2D(MX,MY,sx,sy,sx1,sy1) < 10 then 
            self.LockAxis = true
            self.Axis = 'Z'
            edited = true
            self.dir:Set(x1,y1,z1)
        end

        local x1,y1,z1 = 0,l,0
        if rot then x1,y1,z1 = rot:TransformVector(x1,y1,z1) end
        local sx1,sy1 = R3D.VectorToScreen(x+x1,y+y1,z+z1)    
        if R3D.DistToLine2D(MX,MY,sx,sy,sx1,sy1) < 10 then 
            self.LockAxis = true
            self.Axis = 'Y'
            edited = true
            self.dir:Set(x1,y1,z1)
        end
        
         if R3D.DistToLine2D(MX,MY,sx,sy,sx,sy) < 10 then 
            self.LockAxis = true
            self.Axis = 'Free'
            edited = true
        end

        self.ofx = math.floor(MX - sx)
        self.ofy = math.floor(MY - sy)        
        if MOUSE.RB() == 1 and ax then self.Axis = 'A' .. self.Axis end
    end
   
    if self.LockAxis then          
        if MOUSE.LB() == 2 then -- position            
            local nx,ny,nz = R3D.ScreenTo3D(MX-self.ofx,MY-self.ofy,sz)
            if self.Axis == 'Free' then
                x,y,z = nx,ny,nz
            else
                x,y,z =  R3D.ClosestPointOnLine(nx,ny,nz,x-self.dir.X*1000,y-self.dir.Y*1000,z-self.dir.Z*1000,x+self.dir.X*1000,y+self.dir.Y*1000,z+self.dir.Z*1000)
            end    
        end
        
        if MOUSE.RB() == 2 then -- rotation            
            if math.abs(OMX-MX) > math.abs(OMY-MY) then
                ax = (OMX-MX)/100
            else
                ax = (OMY-MY)/100
            end
            if self.Axis == 'AZ' then ax = -ax end
            self.LockMouse = true
        end
        edited = true
-------------------
	if INP.Key(Keys.A) == 2 then
		if not self.ax then
			self.ax = 0
		else
			self.ax = self.ax + ax
		end

		local pitch = math.pi/12 -- шаг угла поворота 15 градусов (180/12 = 15)
			if math.abs(self.ax) > pitch then
				ax = pitch * (self.ax/math.abs(self.ax))
			--	CONSOLE.AddMessage(ax*180/math.pi.." degree rotation")

				self.ax = 0
			else
				ax = 0
			end
	end
-------------------
    end
    
    if MOUSE.LB() == 3 or MOUSE.RB() == 3 then  
        self.LockAxis = false
    end
    
    return edited,x,y,z,ax,ay,az
end
--============================================================================
function GetJointPos(model,jointname,x,y,z)
    local j = MDL.GetJointIndex(model,jointname)
    if not x then x=0;y=0;z=0 end
    return  MDL.TransformPointByJoint(model,j,x,y,z)
end
--============================================================================
function Editor_EditEntity(entity,class)
    if entity <=0 then return end
    local obj = EntityToObject[entity]
    if obj then 
        Editor:SelectObject(obj)
        EdEntity = obj
    elseif getfenv()[class] then
        local eo = Clone(getfenv()[class])
        eo._Name = ENTITY.GetName(entity)
        eo._Entity = entity        
        local nofile = true
        local fname = "../Data/Levels/"..Lev._Name.."/MapEntities/"..eo._Name.."."..eo._Class
        local f = io.open (fname,"r")        
        if f ~= nil then 
            nofile = false 
            io.close(f)
        end        
        o = eo
        DoFile(fname,false)
        eo:Get(entity,nofile)
        Editor.SelObj = eo
        EdEntity = eo
    else
        Editor:SelectObject(nil)
    end
end
--============================================================================
